package gov.va.med.mhv.vitals.web.validator;

import java.math.BigDecimal;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="LpidisTotalValidator")
public class LpidisTotalValidator implements Validator {
	
	private static final BigDecimal TOTAL_MIN_VALUE = new BigDecimal("10.0");
	private static final BigDecimal TOTAL_MAX_VALUE = new BigDecimal("2000.0");

	@Override
	public void validate(FacesContext context, UIComponent component,Object value) throws ValidatorException {
		
		BigDecimal lipidsTotal=(BigDecimal)value;
		
		if(lipidsTotal.compareTo(TOTAL_MAX_VALUE) > 0){
			String summary = "The Total value must be less than or equal to 2,000.";
			String detail = "Enter a value less than or equal to 2,000.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}else  if(lipidsTotal.compareTo(TOTAL_MIN_VALUE) < 0){
			String summary = "The Total value must be greater than or equal to 10.";
			String detail = "Enter a value greater than or equal to 10.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
		
	}

}
